'use strict';

module.exports = function(grunt) {

  grunt.initConfig({
    pkg: grunt.file.readJSON('package.json'),
    GENISIS_ENV: process.env.GENISIS_ENV || 'development',
    concat: {
      options: {
        separator: '\n'
      },
      js: {
        src: [
          'node_modules/jquery/dist/jquery.js',
          'node_modules/bootstrap/dist/js/bootstrap.js',
          'node_modules/angular/angular.js',
          'node_modules/angular-route/angular-route.js',
          'node_modules/angular-cookies/angular-cookies.js',
          // 'node_modules/angular-modal-service/dst/angular-modal-service.js',
          // 'node_modules/angular-scrollable-table/angular-scrollable-table.js',
          //'env/<%= GENISIS_ENV %>.js',
          'src/**/*.js',
          '!src/**/*.spec.js'
	      ],
        dest: 'dist/js/genisis.js'
      },
      css: {
        src: [
          'node_modules/bootstrap/dist/css/bootstrap.css',
          'src/css/**/*.css'
        ],
        dest: 'dist/css/genisis.css'
      }
    },
    copy: {
      srcToDist: {
        nonull: true,
        files: [
          {
            expand: true,
            cwd: 'src',
            src: [
              '**/*.html',
              '**/*.jpg',
              '**/*.png',
              '**/*.gif',
              '**/*.svg',
              '**/*.ttf',
              '**/*.eot',
              '**/*.woff',
              '**/*.woff2'
            ],
            dest: 'dist/',
            filter: 'isFile'
          },
        ]
      },
      pomToDist: {
        nonull: true,
        files: [
          {
            expand: true,
            cwd: './',
            src: [
              'pom.xml',
            ],
            dest: 'dist/',
            filter: 'isFile'
          },
        ]
      }
    },
    uglify: {
      options: {
        sourceMap: '/dist/js/main-source.js',
        banner: '/*! <%= pkg.name %> <%= pkg.version %> ' +
          '<%= grunt.template.today(\'dd-mm-yyyy\') %> */\n'
      },
      dist: {
        files: {
          'dist/js/genisis.min.js': ['<%= concat.js.dest %>']
        }
      }
    },
    jasmine: {
      src: [
        'node_modules/angular/angular.min.js',
        'node_modules/angular-route/angular-route.min.js',
        'node_modules/angular-cookies/angular-cookies.min.js',
        'node_modules/angular-mocks/angular-mocks.js',
        'node_modules/jquery/dist/jquery.js',
        'node_modules/bootstrap/dist/js/bootstrap.min.js',
        //'env/<%= GENISIS_ENV %>.js',
        'env/env.js',
        'dist/js/env.js',
        'src/**/*.js'
      ]
    },
    jshint: {
      files: [
        'Gruntfile.js',
        //'env/<%= GENISIS_ENV %>.js',
        'dist/js/env.js',
        'src/**/*.js'
      ],
      options: {
        // options here to override JSHint defaults
        jshintrc: true
      }
    },
    htmlhint: {
      options: {
        htmlhintrc: '.htmlhintrc'
      },
      html: {
        src: [
          'src/**/*.html',
          'index.html'
        ]
      }
    },
    csslint: {
      options: {
        csslintrc: '.csslintrc'
      },
      strict: {
        src: ['src/**/*.css']
      }
    },
    jsbeautifier: {
      'js': {
        src: [
          'src/**/*.js'
        ],
        options: {
          config: '.jsbeautifyjs'
        }
      },
      'html': {
        src: [
          'src/**/*.html',
          'index.html'
        ],
        options: {
          config: '.jsbeautifyhtml'
        }
      },
      'css': {
        src: ['src/**/*.css'],
        options: {
          config: '.jsbeautifycss'
        }
      }
    },
    watch: {
      files: [
        '<%= jshint.files %>',
        '<%= htmlhint.html.src %>',
        '<%= csslint.strict.src %>',
        '!_SpecRunner.html',
        '!.grunt'
      ],
      tasks: ['jshint', 'htmlhint', 'csslint', 'jasmine', 'build'],
      options: {
        debounceDelay: 250,
        reload: true,
        dateFormat: function(time) {
          grunt.log.writeln('The watch finished in ' + time + 'ms at ' +
            (new Date()).toString());
          grunt.log.writeln('Waiting for more changes...');
        }
      },
    },
  // fileExists: {
  //   scripts: ['dist/js/env.js']
  // }
});

  //Copying files
  grunt.loadNpmTasks('grunt-contrib-copy');

  //Minification
  grunt.loadNpmTasks('grunt-contrib-concat'); //concatenate files together
  grunt.loadNpmTasks('grunt-contrib-uglify'); //minify js files
  //@TODO minify css files (https://github.com/gruntjs/grunt-contrib-cssmin)

  //Check to see if the dist/js/env.js file exists
  grunt.loadNpmTasks('grunt-file-exists');

  //Javascript
  grunt.loadNpmTasks('grunt-contrib-jshint'); //check files js for errors

  //Formatting
  grunt.loadNpmTasks('grunt-jsbeautifier'); //clean up format

  //Testing
  grunt.loadNpmTasks('grunt-contrib-jasmine'); //run tests

  //Grunt
  grunt.loadNpmTasks('grunt-contrib-watch'); //start grunt watch

  //HTML
  grunt.loadNpmTasks('grunt-htmlhint'); //check for html errors

  //CSS
  grunt.loadNpmTasks('grunt-contrib-csslint'); //check for css errors

  //maven tasks used to release and deploy to Jenkins
  grunt.loadNpmTasks('grunt-maven-tasks');

  //Tasks
  // grunt.registerTask('envExists', ['fileExists']);
  grunt.registerTask('format', ['jsbeautifier']);
  grunt.registerTask('lint', ['jshint', 'htmlhint', 'csslint']);
  grunt.registerTask('test', ['format', 'lint', 'jasmine']);
  grunt.registerTask('build',
    ['format', 'lint', 'concat', 'uglify', 'copy']
  );
  grunt.registerTask('default', ['test', 'concat', 'uglify', 'copy']);
  grunt.registerTask('jenkinsBuild',['test','concat', 'uglify', 'copy']);
};
